# MONINetl.R ex-PDItest.R
# 2008-Ene-05 Viper@upch.edu.pe 2009-Feb-08 

# ======================================================================================================================== #
# call: source("T:/PDItest.R",echo=TRUE,print.eval=TRUE)

setwd("T:\\Temp\\")

date()

#library(foreign) 
library(survey)
library(MASS) 
library(epicalc) 

WkOrDay<- function ( wkd ) { 
	y <- c("Lun","Mar","Mi","Jue","Vie","Sb","Dom")
	w <- 0
	for (i in 1:7) { if (y[i]==wkd) w<-i }
	w }
FANextV<- function ( xAgeLast, vScheme ) { 
	a <- xAgeLast + 12.0
	for ( i in length(vScheme):2 ) {
		if ( xAgeLast < vScheme[i] ) {
			a <- xAgeLast + (vScheme[i]-vScheme[i-1])
			i <- length(vScheme) + 1
		}
	}
	return(a)
}
FSumX<- function ( x, g, xlab ) {
	x<-by(x, g, sum, na.rm=TRUE)
	paste(	xlab, format(x[1]+x[2]+x[3]+x[4]+x[5],trim=TRUE,width=8),
		format(x[1],trim=TRUE,width=8),
		format(x[2],trim=TRUE,width=8),
		format(x[3],trim=TRUE,width=8),
		format(x[4],trim=TRUE,width=8),
		format(x[5],trim=TRUE,width=8) ) }
FSamYld <- function ( xdat ) {
	cat ( 
	"                                       Total   Lima M  R Costa Sierra U Sierra R    Selva",
	FSumX ( xdat$one, xdat$MONIN5,     "Conglomerados (Marco INEI)         " ),
	FSumX ( ifelse(xdat$StatusM==13,1,0), xdat$MONIN5,     "Conglomerados Reemplazados         " ),
	FSumX ( ifelse(xdat$StatusM==15,1,0), xdat$MONIN5,     "Conglomerados Excluidos            " ),
	FSumX ( xdat$NVivs, xdat$MONIN5,   "Viviendas (Marco INEI)             " ),
	FSumX ( xdat$NVivsL, xdat$MONIN5,  "Viviendas (Marcos Locales)         " ),
	FSumX ( xdat$TotVivO, xdat$MONIN5, "Viviendas Enumeradas               " ),
	FSumX ( xdat$NClasV, xdat$MONIN5,  "Viviendas Clasificadas             " ),
	FSumX ( xdat$NEleDes, xdat$MONIN5, "Viviendas Desconocidas             " ),
	FSumX ( xdat$NNoEle, xdat$MONIN5,  "Hogares No Elegibles               " ),
	FSumX ( xdat$NEleNo, xdat$MONIN5,  "Hogares Elegibles Excluidos        " ),
	FSumX ( xdat$NEleRe, xdat$MONIN5,  "Hogares Elegibles Rechazos|Ausentes" ),
	FSumX ( xdat$NCoEViv, xdat$MONIN5, "Hogares Entrevistados              " ),
	FSumX ( xdat$NNi04, xdat$MONIN5,   "Nios 0-4 aos Censados            " ),
	FSumX ( xdat$NNi02, xdat$MONIN5,   "Nios 0-2 aos Censados            " ),
	FSumX ( xdat$NMEF, xdat$MONIN5,    "Mujeres 15-49 aos Censadas        " ),
	FSumX ( xdat$NGes, xdat$MONIN5,    "Mujeres Gestantes Censadas         " ),
	FSumX ( xdat$N04HA, xdat$MONIN5,   "Nios 0-59 meses con Antropometra " ),
	FSumX ( xdat$N04HB, xdat$MONIN5,   "Nios 0-59 meses con Hemoglobina   " ),
	sep = "\n" )
	}
FValN<- function ( n, k ) {  }
FPct <- function ( x ) { 
	ifelse(is.na(x)|is.infinite(x)|is.nan(x),
		"       ",
		ifelse(x>1,
			"  >100%",
			paste(	
				ifelse(x==1,
					"",
					ifelse(x<0.1,"  "," ")),
				format(round(100*x,2),nsmall=2),
				"%",
				sep="" ) ) )
	}
FPctP<- function ( p, v ) { paste ( FPct(p), " [",FPct(sqrt(v)),"]", sep="" ) }
FPctD<- function ( x, d ) { paste ( " ",substr(d,1,1),FPct(x),substr(d,2,2), sep="" ) }
FPRowR<- function ( xnum, xden, xdes, xlab ) { 
	x=svyratio(xnum, xden, design=xdes, na.rm=TRUE);
	y=svyby(xnum,by=~Estrato,denominator=xden,design=xdes,svyratio,na.rm=TRUE);
	paste(xlab,
		"  ", FPctP(x$ratio[1],x$var[1]),
		"  ", FPctP(y$statistics.ratio[[1]],y$statistics.var[[1]]),
		"  ", FPctP(y$statistics.ratio[[2]],y$statistics.var[[2]]),
		"  ", FPctP(y$statistics.ratio[[3]],y$statistics.var[[3]]),
		"  ", FPctP(y$statistics.ratio[[4]],y$statistics.var[[4]]),
		"  ", FPctP(y$statistics.ratio[[5]],y$statistics.var[[5]]), "" ) }
FPRowM<- function ( xnum, xdes, xlab ) { 
	x=svymean(xnum,xdes,na.rm=TRUE,deff=TRUE);
	y=svyby(xnum,by=~Estrato,design=xdes,svymean,na.rm=TRUE,deff=TRUE);
	paste(xlab,
		"  ", FPctP(as.numeric(x[1]),as.numeric(attributes(x)[2])),
		"  ", FPctP(y[1,2],y[1,3]^2),
		"  ", FPctP(y[2,2],y[2,3]^2),
		"  ", FPctP(y[3,2],y[3,3]^2),
		"  ", FPctP(y[4,2],y[4,3]^2),
		"  ", FPctP(y[5,2],y[5,3]^2), "" ) }
FPRwR2<- function ( xnum, xden, xdes, xlab, xby=~Estrato, fplot=FALSE ) { 
	x=svyratio(xnum, xden, design=xdes, na.rm=TRUE);
	y=svyby(xnum,by=xby,denominator=xden,design=xdes,svyratio,na.rm=TRUE);
	s1="";for (i in 1:length(y$statistics.ratio)) s1=paste (s1,"  ", FPctD(y$statistics.ratio[[i]],"  "),sep="");
	s2="";for (i in 1:length(y$statistics.var)) s2=paste (s2,"  ", FPctD(sqrt(y$statistics.var[[i]]),"[]"),sep="");
	if ( fplot ) {
		a=c(x$var[1]); for (i in 1:length(y$statistics.var)) a=c(a,y$statistics.var[[i]])
		b=c(x$ratio[1]); for (i in 1:length(y$statistics.ratio)) b=c(b,y$statistics.ratio[[i]])
		plot(c(0,as.numeric(y[,1])), c(x$ratio[1],y$statistics.ratio),
			ylim=c(0,1), type = "n", bty="n", xaxt="n", las=1,
			xlab="INS/CENAN MONIN 2007-Nov-19 a 2008-Mar-03", ylab="prevalencia e IC95", main=xlab )
		grid(nx=NA, ny=NULL, col="lightgray", lty="solid", lwd=1, equilogs = TRUE)
		arrows(	c(0,as.numeric(y[,1])), (b-1.96*(sqrt(a))), 
			c(0,as.numeric(y[,1])), (b+1.96*(sqrt(a))), 
			code=3, length=0.1, angle=90, col=c("red",rep("blue",times=length(y$statistics.ratio))) )
		points(c(0,as.numeric(y[,1])), c(x$ratio[1],y$statistics.ratio), col=c("red",rep("blue",times=length(y$statistics.ratio))), pch=19, cex=2)
		text(c(0,as.numeric(y[,1])),rep(0,times=1+length(y$statistics.ratio)), c("Total",levels(y[,1])), col=c("red",rep("blue",times=length(y$statistics.ratio)))) }
	cat(	paste(xlab,"  ", FPctD(x$ratio[1],"  "),s1, sep="" ),
		paste(format(" ",trim=TRUE,width=nchar(xlab)),"  ", FPctD(sqrt(x$var[1]),"[]"),s2, sep="" ),
		sep="\n") }
FPRwM2<- function ( xnum, xdes, xlab, xby=~Estrato, fplot=FALSE ) { 
	x=svymean(xnum,xdes,na.rm=TRUE,deff=FALSE);
	y=svyby(xnum,by=xby,design=xdes,svymean,na.rm=TRUE,deff=FALSE);
	s1="";for (i in 1:length(y[,2])) s1=paste (s1,"  ", FPctD(y[i,2],"  "),sep="");
	s2="";for (i in 1:length(y[,3])) s2=paste (s2,"  ", FPctD(y[i,3],"[]"),sep="");
	if ( fplot ) {
		plot(c(0,as.numeric(y[,1])), c(x[1],y[,2]),
			ylim=c(0,1), type = "n", bty="n", xaxt="n", las=1,
			xlab="INS/CENAN MONIN 2007-Nov-19 a 2008-Mar-03", ylab="prevalencia e IC95", main=xlab )
		grid(nx=NA, ny=NULL, col="lightgray", lty="solid", lwd=1, equilogs = TRUE)
		arrows(	c(0,as.numeric(y[,1])), (c(x[1],y[,2])-1.96*c(sqrt(as.numeric(attributes(x)[2])),y[,3])), 
			c(0,as.numeric(y[,1])), (c(x[1],y[,2])+1.96*c(sqrt(as.numeric(attributes(x)[2])),y[,3])), 
			code=3, length=0.1, angle=90,
			col=c("red",rep("blue",times=length(y[,2]))))
		points(c(0,as.numeric(y[,1])), c(x[1],y[,2]), col=c("red",rep("blue",times=length(y[,2]))), pch=19, cex=2)
		text(c(0,as.numeric(y[,1])),rep(0,times=1+length(y[,2])), c("Total",levels(y[,1])), col=c("red",rep("blue",times=length(y[,2])))) }
	cat(	paste(xlab,"  ", FPctD(as.numeric(x[1]),"  "),s1, sep="" ),
		paste(format(" ",trim=TRUE,width=nchar(xlab)),"  ", FPctD(sqrt(as.numeric(attributes(x)[2])),"[]"),s2, sep="" ),
		sep="\n" ) }
FPTbMR<- function ( xvec, xdes, xlab, xden=NA, xby=~Estrato, fratio=FALSE, fplot=FALSE, tplot="ngi1" ) { 
	nv = length(xvec)
	nc = 20	# nc = max(nchar(xlab))
	t = svytable(xby,xdes[[1]],round=TRUE)
	nf = length(t)	# nf = length(levels(xby))
	xp=rep(NA,times=nv*(nf+2));dim(xp)=c(nf+2,nv)
	se=rep(NA,times=nv*(nf+2));dim(se)=c(nf+2,nv)
	for (i in 1:nv) {
		if ( fratio ) {
			x=svyratio(xvec[i][[1]], xden[i][[1]], design=xdes[[i]], na.rm=TRUE);
			y=svyby(xvec[i][[1]],by=xby,denominator=xden[i][[1]],design=xdes[[i]],svyratio,na.rm=TRUE);
			n=dim(y)[1]	# n=length(y$statistics.ratio)
			xp[1,i]=x$ratio[1]
			se[1,i]=sqrt(x$var[1])
			for (j in 1:nf) {
				xp[1+j,i]=NA
				se[1+j,i]=NA
				for(k in 1:n)				  		  {
					if(y[k,1]==labels(t)[[1]][j])			{
						xp[1+j,i]=y[k,2]	#y$statistics.ratio[[k]]
						se[1+j,i]=y[k,3]	#sqrt(y$statistics.var[[k]])
											} }
				}
			xp[nf+2,i]=NA }
		else {
			x=svymean(xvec[i][[1]],design=xdes[[i]],na.rm=TRUE,deff=FALSE)
			y=svyby(xvec[i][[1]],by=xby,design=xdes[[i]],svymean,na.rm=TRUE,deff=FALSE);
			n=length(y[,2])
			xp[1,i]=as.numeric(x[1])
			se[1,i]=sqrt(as.numeric(attributes(x)[2]))
			for (j in 1:nf) {
				xp[1+j,i]=NA
				se[1+j,i]=NA
				for(k in 1:n)				  {
					if(y[k,1]==labels(t)[[1]][j])	{
						xp[1+j,i]=y[k,2]
						se[1+j,i]=y[k,3]	} }
				}
			x = svytable(as.formula(paste("~as.numeric(",all.vars(xby),")+",all.vars(xvec[i][[1]]))),xdes[[i]])
			if ( length(grep("p",tplot))!=0 & 
				length(svytable(xvec[i][[1]],xdes[[i]]))>1 &
				sum(ifelse(dim(x)>1,0,1))==0 
				) {
				# length(levels(xvec[i][[1]]))>1 no es
				z = svychisq(as.formula(paste("~",all.vars(xby),"+",all.vars(xvec[i][[1]]))),xdes[[i]],round=TRUE)
				xp[nf+2,i]=round(z$p.value,6) }
			else { xp[nf+2,i]=NA }  }
		}
	if ( fplot ) {
		if ( length(grep("n",tplot))!=0 ) {
			plot(1:nv, xp[1,],
				ylim=c(0,1), type = "n", bty="n", xaxt="n", las=1,
				xlab="INS/CENAN MONIN 2007-Nov-19 a 2008-Mar-03 y 2008-Jun-30 a 2008-Oct-04",
				ylab="proporcin e IC95", main="Nacional" )
			grid(nx=NA, ny=NULL, col="lightgray", lty="solid", lwd=1, equilogs = TRUE)
			arrows(1:nv, xp[1,]-1.96*se[1,], 1:nv, xp[1,]+1.96*se[1,], code=3, length=0.1, angle=90, col=1:nv)
			points(1:nv, xp[1,], col=1:nv, pch=19, cex=2)
			text(1:nv,rep(0,times=nv), xlab, col=1:nv,cex=0.75) }
		if ( length(grep("g",tplot))!=0 ) {
			plot(1:nv, xp[1,],
				ylim=c(0,1), type = "n", bty="n", xaxt="n", las=1,
				xlab="INS/CENAN MONIN 2007-Nov-19 a 2008-Mar-03 y 2008-Jun-30 a 2008-Oct-04",
				ylab="proporcin e IC95", main="Nacional y por Grupos" )
			grid(nx=NA, ny=NULL, col="lightgray", lty="solid", lwd=1, equilogs = TRUE)
			for (j in 1:(nf+1)) { 
				lines(1:nv, xp[j,], col=j, lty=1, pch=j)
				points(1:nv, xp[j,], col=j, pch=j ) }
			text(1:nv,rep(0,times=nv), xlab, col=1:nv,cex=0.75)
			legend("topright", bg="white", legend=c("Total",labels(t)[[1]]),
				col=1:(nf+1), pch=1:(nf+1), lty=1:(nf+1), cex=0.75) }
		if ( length(grep("i",tplot))!=0 ) {
			for (i in 1:nv ) {
				plot(0:nf, c(xp[1:(nf+1),i]),
					ylim=c(0,1), type = "n", bty="n", xaxt="n", las=1,
					xlab="INS/CENAN MONIN 2007-Nov-19 a 2008-Mar-03 y 2008-Jun-30 a 2008-Oct-04",
					ylab="proporcin e IC95", main=paste("Indicador ",xlab[[i]]) )
				grid(nx=NA, ny=NULL, col="lightgray", lty="solid", lwd=1, equilogs = TRUE)
				arrows( 0:nf, (xp[1:(nf+1),i]-1.96*se[1:(nf+1),i]),
					0:nf, (xp[1:(nf+1),i]+1.96*se[1:(nf+1),i]), 
					code=3, length=0.1, angle=90,col=c("red",rep("blue",times=nf)))
				points(0:nf, xp[1:(nf+1),i], col=c("red",rep("blue",times=nf)), pch=19, cex=2)
				text(0:nf,rep(0,times=1+nf), c("Total",labels(t)[[1]]),
					col=c("red",rep("blue",times=nf+1)),cex=0.75) } }
		if ( length(grep("b",tplot))!=0 ) {
			for (j in 1:(nf+1)) { 
				plot(c(0.8,1:nv,nv+0.2), c(NA,xp[j,],NA),
					ylim=c(-0.05,1), type = "n", bty="n", xaxt="n", las=1,
					xlab="INS/CENAN MONIN 2007-Nov-19 a 2008-Mar-03 y 2008-Jun-30 a 2008-Oct-04", 
					ylab="proporcin e IC95",
					main=ifelse(j==1,"Total Nacional",labels(t)[[1]][j-1]) )
				grid(nx=NA, ny=NULL, col="lightgray", lty="solid", lwd=1, equilogs = TRUE)
				arrows(	c(0.8,1:nv,nv+0.2), c(0,(xp[j,]-1.96*se[j,]),0),
					c(0.8,1:nv,nv+0.2), c(0,(xp[j,]+1.96*se[j,]),0), 
					code=3, length=0.05, angle=90,
					col="lightgray" )
				rect(	c(0.7,(1:nv)-0.1,nv-0.1), c(0,rep(0,times=(nv)),0),
					c(0.9,(1:nv)+0.1,nv+0.1), c(0,xp[j,],0),
					density=36,
					angle = c(90,ifelse(xp[j,]<0.5,45,ifelse(xp[j,]<0.8,0,135)),90),
					col=c("lightgray",ifelse(xp[j,]<0.5,"darkred",ifelse(xp[j,]<0.8,"orange","darkgreen")),"lightgray"),
					border=c("lightgray",ifelse(xp[j,]<0.5,"red",ifelse(xp[j,]<0.8,"orange","darkgreen")),"lightgray"))
				text(c(0.8,1:nv,nv+0.2),rep(-0.05,times=nv+2), c(NA,xlab,NA),
					col=rep("black",times=(nv+2)),cex=0.625) } }
				#points(1:nv, xp[j,], col=ifelse(xp[j,]<0.5,"red",ifelse(xp[j,]<0.8,"yellow","green")), pch=j )
				# angle = 45, density=72*(1-xp[j,])
		}
	if ( length(grep("1",tplot))!=0 ) {
		s1=paste("\n",format("Grupo",width=nc),"     ", format("Total",width=11), sep="");
		for (j in 1:nf) s1=paste (s1," ", format(substr(labels(t)[[1]][j],1,10),width=10,trim=TRUE)," ",sep="");
		s1=paste(s1,"p",sep="");
		cat( s1, format(" ",trim=TRUE,width=nc), sep="\n" )
		#paste(format(" ",trim=TRUE,width=nc),"  ", s1, sep="" )
		s1=paste(format("n ponderado",width=nc), format(sum(t),trim=TRUE,width=11), sep="");
		for (j in 1:nf) s1=paste (s1,"  ", format(t[j],trim=TRUE,width=10),"  ",sep="")
		cat( s1, format(" ",trim=TRUE,width=nc), sep="\n" )
		for (i in 1:nv ) {
			s1="";for (j in 1:(nf+1)) s1=paste (s1,"  ", FPctD(xp[j,i],"  "),sep="");s1=paste (s1,"  ", xp[nf+2,i], sep="")
			s2="";for (j in 1:(nf+1)) s2=paste (s2,"  ", FPctD(se[j,i],"[]"),sep="");
			cat(	paste(format(xlab[[i]],trim=TRUE,width=nc),"  ", s1, sep="" ),
				paste(format(" ",trim=TRUE,width=nc),"  ", s2, sep="" ),
				sep="\n" ) } }
	if ( length(grep("w",tplot))!=0 ) {
		s1=paste("\n", format("Grupo",width=nc),"     ", format("Total",width=20), sep="");
		for (j in 1:nf) s1=paste (s1," ", format(substr(labels(t)[[1]][j],1,10),width=20,trim=TRUE)," ",sep="");
		s1=paste(s1, format("nw",width=10), format("p",width=10), sep="");
		cat( s1, format(" ",trim=TRUE,width=nc), sep="\n" )
		for (i in 1:nv ) {
			s1=""
			for (j in 1:(nf+1)) s1=paste (s1,"  ", FPctD(xp[j,i],"  "),"  ", FPctD(se[j,i],"[]"),sep="")
			s1=paste (s1,"  ", format(sum(t),trim=TRUE,width=10), "  ", xp[nf+2,i], sep="")
			cat(	paste(format(xlab[[i]],trim=TRUE,width=nc),"  ", s1, sep="" ), sep="\n" ) }
		}
	}
LimsRRTWk <- function ( xobj=xt, kw=52, P0=0.5, OR=TRUE ) {
	h = 1.96*xobj$coefficients[2,2]
	m = xobj$coefficients[2,1]
	a = exp ( m - h ) ^ kw
	b = exp ( m + h ) ^ kw
	if ( !OR ) {
		a = a / ( 1 + (P0*(a-1)) )
		b = b / ( 1 + (P0*(b-1)) ) }
	c(a,b)
	}
TrendWk <- function ( xdep="N5DTE", xdes=p5 ) {
	kw=52;
	P0=round(svymean(as.formula(paste("~",xdep,sep="")),xdes,na.rm=TRUE,deff=TRUE)[1],2)
	x1=summary(svyglm(as.formula(paste(xdep,"~EvEpiWk",sep="")),subset(xdes,Crecer=="Crecer"),family=binomial(link="logit")))
	x0=summary(svyglm(as.formula(paste(xdep,"~EvEpiWk",sep="")),subset(xdes,Crecer=="Resto"),family=binomial(link="logit")))
	xt=summary(svyglm(as.formula(paste(xdep,"~EvEpiWk",sep="")),xdes,family=binomial(link="logit")))
	xx=summary(svyglm(as.formula(paste(xdep,"~EvEpiWk*Crecer",sep="")),xdes,family=binomial(link="logit")))
	paste(	format(xdep,width=10), "  ", FPct(P0), " [",
		format(round(LimsRRTWk(xt,kw,P0,FALSE)[1],2),nsmall=2,width=5), ",",
		format(round(LimsRRTWk(xt,kw,P0,FALSE)[2],2),nsmall=2,width=5), "] [",
		format(round(LimsRRTWk(x1,kw,P0,FALSE)[1],2),nsmall=2,width=5), ",",
		format(round(LimsRRTWk(x1,kw,P0,FALSE)[2],2),nsmall=2,width=5), "] [",
		format(round(LimsRRTWk(x0,kw,P0,FALSE)[1],2),nsmall=2,width=5), ",",
		format(round(LimsRRTWk(x0,kw,P0,FALSE)[2],2),nsmall=2,width=5), "] ",
		format(round(xt$coefficients[2,4],3),nsmall=3,width=5), "  ",
		format(round(xx$coefficients[2,4],3),nsmall=3,width=5), "  ",
		format(round(xx$coefficients[3,4],3),nsmall=3,width=5), "  ",
		format(round(xx$coefficients[4,4],3),nsmall=3,width=5), "  ",
		sep="" )
	}
FPTbP1<- function ( pvar, gvar, xdes, xdat, xlab, xden=NA, fratio=FALSE ) { 
	nwr = 25; nwc = 8
	lv = levels(xdat[,c(gvar)])
	tc = table(xdat[,c(gvar)],xdat[,c(pvar)])
	tp = svytable(as.formula(paste("~",gvar,"+",pvar,sep="")),xdes,round=TRUE,Ntotal=sum(tc))
	nf = dim(tc)[1] ; nc = dim(tc)[2] ; nr = length(tp[,1]) ; nn = length(lv)
	nt=rep(NA,times=(nn+2));dim(nt)=c(nn+2)
	np=rep(NA,times=(nn+2));dim(np)=c(nn+2)
	xp=rep(NA,times=(nn+2));dim(xp)=c(nn+2)
	se=rep(NA,times=(nn+2));dim(se)=c(nn+2)
	if ( fratio ) {
		x=svyratio(as.formula(paste("~",pvar,sep="")), xden, design=xdes, na.rm=TRUE);
		y=svyby(xdat[,c(pvar)],by=as.formula(paste("~",gvar,sep="")),denominator=xden,design=xdes,svyratio,na.rm=TRUE)
		n=length(y$statistics.ratio)
		xp[nn+1]=x$ratio[1]
		se[nn+1]=sqrt(x$var[1])
		for (i in 1:nn) {
			xp[i]=NA
			se[i]=NA
			if (n>1) { for(k in 1:n)	 			  {
				if(y[k,1]==lv[i])				{				nt[i]=sum(tc[i,])
					np[i]=sum(tp[i,])
					xp[i]=y$statistics.ratio[[k]]
					se[i]=sqrt(y$statistics.var[[k]])	} } }
			}
		}
	else	{
		x=svymean(as.formula(paste("~",pvar,sep="")),design=xdes,na.rm=TRUE,deff=FALSE)
		y=svyby(xdat[,c(pvar)],by=as.formula(paste("~",gvar,sep="")),design=xdes,svymean,na.rm=TRUE,deff=FALSE)
		n=length(y[,2])
		xp[nn+1]=as.numeric(x[1])
		se[nn+1]=sqrt(as.numeric(attributes(x)[2]))
		for (i in 1:nn) {
			xp[i]=NA
			se[i]=NA
			if (n>1) { for(k in 1:n)	  {
				if(y[k,1]==lv[i])	{
					nt[i]=sum(tc[k,])
					np[i]=sum(tp[k,])
					xp[i]=y[k,2]
					se[i]=y[k,3]	} } }
			}
		}
	s = paste(
		format(paste(xlab," [",gvar,"]",sep=""),width=nwr), " ",
		format(FPct(xp[nn+1]),width=nwc), " ",
		format(FPct(se[nn+1]),width=nwc), " [",
		format(FPct(xp[nn+1]-1.96*se[nn+1]),width=nwc), ",",
		format(FPct(xp[nn+1]+1.96*se[nn+1]),width=nwc), "] ",
		format(sum(tc),width=nwc), " ",
		format(sum(tp),width=nwc), " ",
		sep="")
	for (i in 1:nn) {
		s = cat ( s, "\n", 
			paste(
				format(lv[i],width=nwr), " ",
				format(FPct(xp[i]),width=nwc), " ",
				format(FPct(se[i]),width=nwc), " [",
				format(FPct(xp[i]-1.96*se[i]),width=nwc), ",",
				format(FPct(xp[i]+1.96*se[i]),width=nwc), "] ",
				format(nt[i],width=nwc), " ",
				format(np[i],width=nwc), " ",
				sep="" ),
			sep ="" )
		}	
	cat ( s, " ", sep="\n" ) }
FPanel1 <- function ( xvar, xlab, xdesP=p5, xdesN=n5 ) {
	nwr = 25; nwc = 8
	cat(	xlab, " [",xvar,"] ", "\n", 
		format("Grupo",width=nwr), " ",
		format("Prev.",width=nwc), " ",
		format("ES",width=nwc), "  ",
		format("L.Inf95",width=nwc), " ",
		format("L.Sup95",width=nwc), "  ",
		format("n s/p",width=nwc), " ",
		format("n pond.",width=nwc), " \n",
		sep="" )
	FPTbP1 ( xvar, "gedad", xdesP, xdesN, "Grupo de Edad" )
	FPTbP1 ( xvar, "Sexo", xdesP, xdesN, "Sexo" )
	FPTbP1 ( xvar, "Estrato", xdesP, xdesN, "Estrato" )
	FPTbP1 ( xvar, "fINEIE2", xdesP, xdesN, "rea" )
	FPTbP1 ( xvar, "fINEIE8", xdesP, xdesN, "Dom.Demogrfico" )
	FPTbP1 ( xvar, "RegNat", xdesP, xdesN, "Regin Natural" )
	FPTbP1 ( xvar, "Crecer", xdesP, xdesN, "Crecer" )
	FPTbP1 ( xvar, "fNBI", xdesP, xdesN, "NBI" )
	FPTbP1 ( xvar, "Periodo", xdesP, xdesN, "Periodo" )
	}
FPanel2 <- function ( xvar, xlab, xdesP=pf, xdesN=mf ) {
	nwr = 25; nwc = 8
	cat(	xlab, " [",xvar,"] ", "\n", 
		format("Grupo",width=nwr), " ",
		format("Prev.",width=nwc), " ",
		format("ES",width=nwc), "  ",
		format("L.Inf95",width=nwc), " ",
		format("L.Sup95",width=nwc), "  ",
		format("n s/p",width=nwc), " ",
		format("n pond.",width=nwc), " \n",
		sep="" )
	FPTbP1 ( xvar, "gedad", xdesP, xdesN, "Grupo de Edad" )
	#FPTbP1 ( xvar, "EFisM", xdesP, xdesN, "Est. Fisiolgico" )
	FPTbP1 ( xvar, "Estrato", xdesP, xdesN, "Estrato" )
	FPTbP1 ( xvar, "fINEIE2", xdesP, xdesN, "rea" )
	FPTbP1 ( xvar, "fINEIE8", xdesP, xdesN, "Dom.Demogrfico" )
	FPTbP1 ( xvar, "RegNat", xdesP, xdesN, "Regin Natural" )
	FPTbP1 ( xvar, "Crecer", xdesP, xdesN, "Crecer" )
	FPTbP1 ( xvar, "fNBI", xdesP, xdesN, "NBI" )
	FPTbP1 ( xvar, "Periodo", xdesP, xdesN, "Periodo" )
	}
FPack1<- function ( xby=~Estrato, fplot=FALSE, tplot="ngi" ) { 
	t<-"===== Nios 0-59 meses, Nutricin";t
	FPTbMR ( xvec=c(~N5DTE9,~N5ADE9,~N5OBE9,~N5Ane,~N5Ret),
	 xdes=list(p5,p5,p5,subset(p5,EdadM>=6),subset(p5,EdadM>=6 & !is.na(Retinol))),
	 xlab=c("TE<-2z 79","PT<-2z 79","PT>2z 79","Anemia","Def.Ret."), 
	 xby=xby, fratio=FALSE, fplot=fplot, tplot=tplot ) 
	t<-"===== Nios 0-59 meses, Alimentacin";t
	FPTbMR ( xvec=c(~IPConLM,~N5LME,~IPVComio,~MasGra,~IPVitA,~IPVFe,~IPSal15,~N5Ali),
	 xdes=list(subset(p3,EdadM<24),subset(p5,EdadM<6),subset(p3,EdadM>=6 & EdadM<24),
		subset(p3,EdadM>=6 & EdadM<24),subset(p3,EdadM>=6 & EdadM<24 & Periodo!="2008-III"),
		subset(p3,EdadM>=6 & EdadM<24 & Periodo!="2008-III"),p5,subset(p5,N5SaY==0)),
	 xlab=c("LM[<24]","LME[<6]","3SS[6-23]","Grasa[6-23]","Vit.A[6-23]","S.Fe[6-23]","Sal I","Alim.Enf."), 
	 xby=xby, fratio=FALSE, fplot=fplot, tplot=tplot ) 
	t<-"===== Nios 0-59 meses, Salud";t
	FPTbMR ( xvec=c(~IPPFie2w,~IPPTos2w,~NER7,~NumeIR,~NumeRR,~IPPDia2w,~NED7,~NumeID,~NumeRD),
	 xdes=list(p5,p5,p5,p5,p5,p5,p5,p5,p5),
	 xlab=c("Fieb 2s","IRAb 2s","pIRA","iIRA","rIRA","EDA 2s","pEDA","iEDA","rEDA"), 
	 xden=c(~one,~one,~DenomP,~DenomIR,~DenomRR,~one,~DenomP,~DenomID,~DenomRD), 
	 xby=xby, fratio=TRUE, fplot=fplot, tplot=tplot ) 
	t<-"===== Nios 0-59 meses, Atencin";t
	FPTbMR ( xvec=c(~N5CC0,~IPNVBCG,~IPNVPOL,~IPNVDPT,~IPNVHEP,~IPNVHIB,~IPNVSAR,~IPNVPaR,~IPNVAMA),
	 xdes=list(subset(p3,EdadM<24),subset(p3,EdadM>=6&EdadM<24),
		subset(p3,EdadM>=6&EdadM<24),subset(p3,EdadM>=6&EdadM<24),subset(p3,EdadM>=6&EdadM<24),subset(p3,EdadM>=6&EdadM<24),
		subset(p3,EdadM>=12&EdadM<24),subset(p3,EdadM>=12&EdadM<24),subset(p3,EdadM>=12&EdadM<24)),
	 xlab=c("CRED<1a[<24]","BCG[6-23]","Polio[6-23]","DPT[6-23]","Hep.[6-23]","HiB[6-23]","Sar[12-23]","R+P[12-23]","FAm[12-23]"), 
	 xby=xby, fratio=FALSE, fplot=fplot, tplot=tplot ) 
	t<-"===== Nios 0-59 meses, Cuidado";t
	FPTbMR ( xvec=c(~MaPte,~IPMaEdu1,~IPMaEdu2,~IPMaEdu3,~IPNMSD,~IPNMCCD),
	 xdes=list(p5,p5,p5,p5,p5,p5),
	 xlab=c("M.Pte.","M.Alfab.","M.Prim.","M.Sec.","SD<6m","CRED c/Cont."), 
	 xby=xby, fratio=FALSE, fplot=fplot, tplot=tplot ) 
	t<-"===== Nios 0-59 meses, Vivienda";t
	FPTbMR ( xvec=c(~IPAlumbra,~IPAgua,~IPAgRTC,~IPAgRTH,~IPAgBac,~IPExcre1,~IPExcre3,~IPTCoc1,~IPTCoc2),
	 xdes=list(p5,p5,p5,p5,subset(p5,Periodo!="2008-I"),p5,p5,p5,p5),
	 xlab=c("Elec.","Agua RD","Agua Cl","Agua H","Agua B-","Excr RD","Letr Ad.","Coc E/G","Coc Mej."), 
	 xby=xby, fratio=FALSE, fplot=fplot, tplot=tplot ) 
	t<-"===== Nios 0-59 meses, Comunidad";t
	FPTbMR ( xvec=c(~IPCUI,~IPSeg,~IPNBI,~IPNJtos,~IPSIS,~IPNBAA,~IPNBAA),
	 xdes=list(p5,subset(p5,Periodo!="2008-I"),p5,subset(p5,NBI>0),subset(p5,NBI>0),subset(p5,NBI>0),subset(p5,NBI==0)),
	 xlab=c("CUI","SS+","P=NBI>0","Juntos [P]","SIS [P]","AA [P]","AA[noP]"), 
	 xby=xby, fratio=FALSE, fplot=fplot, tplot=tplot ) 
	FPTbMR ( xvec=c(~IPNBPIN,~IPEBPIN,~IPNPapB,~IPNBVAL,
		~IPNBWW,~IPNBCOI,~IPNBTBC,~IPNBCOP,~IPNBPRV),
	 xdes=list(subset(p5,NBI>0),subset(p3,Crecer=="Crecer" & QMEF<3 & EdadM>=6),subset(p3,NBI>0 & EdadM>=6),subset(p5,NBI>0),
		subset(p5,NBI>0),subset(p5,NBI>0),subset(p5,NBI>0),subset(p5,NBI>0),subset(p5,NBI>0)),
	 xlab=c("PIN[P]","PIN[QC]","Pap [P, 6-35m]","VL[P]",
		"WW[P]","CoI[P]","TBC[P]","CoP[P]","Priv[P]"), 
	 xby=xby, fratio=FALSE, fplot=fplot, tplot=tplot ) 
	t<-"===== Mujeres 12-49 aos, Nutricin";t
	FPTbMR ( xvec=c(~IPOBE,~IPANE,~IPRET,~IPYOD),
	 xdes=list(pf,pf,subset(pf,!is.na(Retinol)),subset(pf,!is.na(Yoduria))),
	 xlab=c("IMC>25 [MEF]","Hb<12 [MEF]","Ret<20 [MEF]","IU<10 [MEF]"), 
	 xby=xby, fratio=FALSE, fplot=fplot, tplot=tplot ) 
	}
FSimp1<- function ( xvar=~N5DTE, xdes=p5, xby=~Estrato, xden=NULL, fratio=FALSE ) { 
	FPTbMR ( xvec=c(xvar), xdes=list(xdes), xlab=c("x"), xden=xden,
	 xby=xby, fratio=FALSE, fplot=FALSE, tplot="ngip" ) 
	}
DescMod1<- function ( xdep, xdat, xset ) { 
	summary(stepAIC(glm(xdep~
	EdadM+Edad2+csexo+NBI+nHV109+cagua+nINEIE8+lINEIE8+ALMPM+FALT+FALT2+fINEIER+Estrato+WkDay,
	data=xdat,subset=xset,family=binomial(link="logit"),na.action=na.exclude),trace=FALSE)) }
DescMod2<- function ( xdep, xdat, xset ) {
	summary(stepAIC(glm(xdep~
	EdadM+Edad2+csexo+NBI+cagua+nINEIE8+lINEIE8+ALMPM+FALT+FALT2+fINEIER+Estrato+WkDay,
	data=xdat,subset=xset,family=binomial(link="logit"),na.action=na.exclude),trace=FALSE)) }
DescMod3<- function ( xdep, xdat, xset ) {
	summary(stepAIC(glm(xdep~
	EdadM+Edad2+csexo+nHV109+cagua+nINEIE8+lINEIE8+ALMPM+FALT+FALT2+fINEIER+Estrato+WkDay,
	data=xdat,subset=xset,family=binomial(link="logit"),na.action=na.exclude),trace=FALSE)) }
DescMod4<- function ( xdep, xdat, xset ) {
	summary(stepAIC(glm(xdep~
	EdadM+Edad2+csexo+NBI+nHV109+nINEIE8+lINEIE8+ALMPM+FALT+FALT2+fINEIER+Estrato+WkDay,
	data=xdat,subset=xset,family=binomial(link="logit"),na.action=na.exclude),trace=FALSE)) }
DescMod5<- function ( xdep, xdat, xset ) {
	summary(stepAIC(glm(xdep~
	EdadM*Edad2+nINEIE8*lINEIE8+FALT*FALT2*nVertOc,
	data=xdat,subset=xset,family=binomial(link="logit"),na.action=na.exclude),trace=FALSE)) }


# ======================================================================================================================== #
t<-"===== MONIN 2008 0-59m Ronda 1";t;date()
tc<-read.csv("T.csv") 
tc$one = 1
tc$StatusM=ifelse(tc$Cong==253|tc$Cong==187|tc$Cong==161,13,tc$StatusM)
tc$P1R=tc$P1R*(1E-9)
tc$P2R=tc$P2R*(1E-6)
tc$P1N=tc$P1N*(1E-9)
tc$P1M=tc$P1M*(1E-9)
tc$ExFVi=tc$SWt*7487741/sum(tc$SWt)
tc$fecha=as.date(substr(tc$FIniCong,1,10),"dmy")
tc$ddias=difftime(as.date(substr(tc$FFinCong,1,10),"dmy"),tc$fecha,unit="days") + 1
tc$iyear=as.numeric(format(as.Date(tc$fecha),"%Y"))
tc$imonth=as.numeric(format(as.Date(tc$fecha),"%m"))
tc$ijdoy=as.integer(difftime(as.Date(tc$fecha),as.Date(paste(as.character(tc$iyear),"-01-01",sep="")),unit="days"))
tc$WkDay=0
for (i in 1:length(tc$WkDay)) tc$WkDay[i]<-ifelse(is.na(tc$fecha[i]),NA,WkOrDay(weekdays(as.Date(tc$fecha[i]),abbreviate=TRUE)))
tc$EvEpiWk=as.integer(difftime(as.Date(tc$fecha),as.Date("1960-01-01"),unit="weeks"))
tc$EvEpiMo=as.integer(tc$EvEpiWk/4)
n5<-read.csv("P.csv") 
n5$one = 1
n5$pzho=ifelse(n5$HFAZ<(-2),1,0)
n5$HbCORR=ifelse(n5$HbCORR==-1,NA,n5$HbCORR)
n5$EstClu=as.numeric(n5$Estrato)*100+5*n5$Salida
n5$RegNat = factor(ifelse(n5$Estrato==1|n5$Estrato==2,1,ifelse(n5$Estrato==5,3,2)),labels=c("Costa","Sierra","Selva"))
n5$Estrato=factor(n5$Estrato,labels=c("Lima M","R Costa","Sierra U","Sierra R","Selva"))
ifelse(n5$EdadM<60 & !is.na(n5$ZHAZ),1,0) -> n5$N5DTED
ifelse(n5$EdadM<60 & !is.na(n5$ConAL),1,0) -> n5$N5CCDD
ifelse(n5$EdadM<12 & !is.na(n5$ConAL),1,0) -> n5$N5CC0D
ifelse(n5$EdadM<60 & !is.na(n5$ConAL),1,0) -> n5$N5AliD
ifelse(n5$EdadM<60 & !is.na(n5$VivOK),1,0) -> n5$N5VIVD
ifelse(n5$EdadM<60 & !is.na(n5$ZHAZ),1,0) -> n5$N5NutD
ifelse(n5$EdadM<60 & !is.na(n5$HbCORR),1,0) -> n5$N5AneD
ifelse(n5$EdadM<60 & !is.na(n5$ZWHZ),1,0) -> n5$N5OBED
ifelse(n5$EdadM<60 & !is.na(n5$ZHAZ),
	ifelse(n5$EdadM<60 & n5$ZHAZ < -2,1,0),NA) -> n5$N5DTE
ifelse(n5$EdadM<60 & !is.na(n5$ZWHZ),
	ifelse(n5$EdadM<60 & n5$ZWHZ < -2,1,0),NA) -> n5$N5ADE
ifelse(n5$EdadM<60 & !is.na(n5$ZWHZ),
	ifelse(n5$EdadM<60 & n5$ZWHZ > 2,1,0),NA) -> n5$N5OBE
ifelse(n5$EdadM<60 & !is.na(n5$HFAZ),
	ifelse(n5$EdadM<60 & n5$HFAZ < -2,1,0),NA) -> n5$N5DTE9
ifelse(n5$EdadM<60 & !is.na(n5$WFHZ),
	ifelse(n5$EdadM<60 & n5$WFHZ < -2,1,0),NA) -> n5$N5ADE9
ifelse(n5$EdadM<60 & !is.na(n5$WFHZ),
	ifelse(n5$EdadM<60 & n5$WFHZ > 2,1,0),NA) -> n5$N5OBE9
ifelse(n5$EdadM<60 & !is.na(n5$HbCORR),
	ifelse(n5$EdadM<60 & n5$HbCORR < 11,1,0),NA) -> n5$N5Ane
n5$N5Nut <- ifelse(n5$EdadM<60 & !is.na(n5$ZHAZ),
	ifelse(n5$ZHAZ>=-2 & n5$ZWHZ>=-2 & n5$ZWHZ<2,1,0),NA)
ifelse(n5$EdadM<60 & !is.na(n5$Retinol),
	ifelse(n5$Retinol < 20,1,0),NA) -> n5$N5Ret
ifelse(n5$EdadM<60 & !is.na(n5$ConAL) & (
	(n5$EdadM<6 & n5$ConLM==1 & n5$ConAL!=1) | 
	(n5$EdadM>=6 & n5$EdadM<11 & n5$ConLM==1 & n5$AliOK==1 & (n5$SupOK==1|(n5$NEDY!=0|n5$NERY!=0)) & n5$NVVTA>0) | 
	(n5$EdadM>=12 & n5$EdadM<18 & n5$ConLM==1 & n5$AliOK==1 & n5$NVVTA>1) | 
	(n5$EdadM>=18 & n5$EdadM<24 & n5$ConLM==1 & n5$AliOK==1 & n5$NVVTA>2) | 
	(n5$EdadM>=24 & n5$AliOK==1)),1,0) -> n5$N5Ali
ifelse(n5$EdadM<6 & !is.na(n5$ConAL),ifelse(n5$EdadM<6 & n5$ConLM==1 & n5$ConAL!=1,1,0),NA) -> n5$N5LME
ifelse(n5$EdadM<60 & !is.na(n5$ConAL) & n5$PDia2w==2 & n5$PTos2w==3 & n5$PFie2w==2,1,0) -> n5$N5San
ifelse(n5$EdadM<60 & !is.na(n5$ConAL), ifelse(n5$NEDY==0 & n5$NERY==0,1,0),NA) -> n5$N5SaY
x=1.0; y=0.0; t=FALSE
ifelse(n5$EdadM<60 & !is.na(n5$ConAL) & (
	(n5$EdadM<((2*x)+y)				& n5$NVBCG>0 & (t|(n5$NVHEP>0))) | 
	(n5$EdadM>=((2*x)+y) & n5$EdadM<((4*x)+y)	& n5$NVBCG>0 & n5$NVDPT>0 & n5$NVPOL>0 & (t|(n5$NVHEP>1 & n5$NVHIB>0))) | 
	(n5$EdadM>=((4*x)+y) & n5$EdadM<((6*x)+y)	& n5$NVBCG>0 & n5$NVDPT>1 & n5$NVPOL>1 & (t|(n5$NVHEP>2 & n5$NVHIB>1))) | 
	(n5$EdadM>=((6*x)+y) & n5$EdadM<((12*x)+y)	& n5$NVBCG>0 & n5$NVDPT>2 & n5$NVPOL>2 & (t|(n5$NVHEP>3 & n5$NVHIB>2))) | 
	(n5$EdadM>=((12*x)+y) & n5$EdadM<((18*x)+y)	& n5$NVBCG>0 & n5$NVDPT>2 & n5$NVPOL>2 & (t|(n5$NVHEP>3 & n5$NVHIB>2)) & n5$NVSAR>0 & n5$NVPaR>0 & n5$NVAMA>0) |
	(n5$EdadM>=((18*x)+y) & n5$EdadM<((48*x)+y)	& n5$NVBCG>0 & n5$NVDPT>3 & n5$NVPOL>2 & (t|(n5$NVHEP>3 & n5$NVHIB>2)) & n5$NVSAR>0 & n5$NVPaR>0 & n5$NVAMA>0) |
	(n5$EdadM>=((48*x)+y)				& n5$NVBCG>0 & n5$NVDPT>4 & n5$NVPOL>2 & (t|(n5$NVHEP>3 & n5$NVHIB>2)) & n5$NVSAR>1 & n5$NVPaR>1 & n5$NVAMA>0) 
	),1,0) -> n5$N5PIP
ifelse(!is.na(n5$EdadM) & !is.na(n5$ConAL) & (
	(n5$EdadM<1 & n5$NCCD0>(1+(n5$EdadM-0)/0.5)) | 
	(n5$EdadM>=1 & n5$EdadM<2 & n5$NCCD0>(3+(n5$EdadM-1)/1)) | 
	(n5$EdadM>=2 & n5$EdadM<6 & n5$NCCD0>(5+(n5$EdadM-2)/2)) | 
	(n5$EdadM>=6 & n5$EdadM<24 & n5$NCCD0>(7+(n5$EdadM-6)/3)) | 
	(n5$EdadM>=24 & n5$NCCD0>(12+(n5$EdadM-24)/6)) ),1,0) -> n5$N5CCD
ifelse(!is.na(n5$EdadM) & !is.na(n5$ConAL) & (
	(n5$EdadM<0.0657                     ) |
	(n5$EdadM>=0.0657 & n5$EdadM<0.23    & n5$NCCD0>0) |
	(n5$EdadM>=0.23 & n5$EdadM<1         & n5$NCCD0>1) |
	(n5$EdadM>=1 & n5$EdadM<2            & n5$NCCD0>2) | 
	(n5$EdadM>=2 & n5$EdadM<4            & n5$NCCD0>3) | 
	(n5$EdadM>=4 & n5$EdadM<6            & n5$NCCD0>4) | 
	(n5$EdadM>=6 & n5$EdadM<7            & n5$NCCD0>5) | 
	(n5$EdadM>=7 & n5$EdadM<9            & n5$NCCD0>6) | 
	(n5$EdadM>=9 & n5$EdadM<12           & n5$NCCD0>7) | 
	(n5$EdadM>=12                        & n5$NCCD0>8) ),1,0) -> n5$N5CC0
n5$ECCD0=ifelse (n5$ECCD0<0,-1,n5$ECCD0/30.4375)
n5$UCCD0=ifelse (n5$ECCD0<0,100,ifelse(n5$EdadM>n5$ECCD0,n5$EdadM-n5$ECCD0,0))	# distancia a ltima visita, meses
x=ifelse(n5$EdadM<1,0.5,ifelse(n5$EdadM<2,1,ifelse(n5$EdadM<6,2,ifelse(n5$EdadM<24,3,ifelse(n5$EdadM<60,6,1)))))
n5$PCCD0=ifelse(n5$EdadM>=12,NA,ifelse(n5$UCCD0>x,0,ifelse(n5$UCCD0>x,(n5$EdadM-n5$UCCD0)-(n5$EdadM-x),n5$UCCD0))/x)
n5$PCCD30=ifelse(n5$EdadM>=12,NA,ifelse((n5$UCCD0+x)>n5$EdadM,1,ifelse((n5$UCCD0+x)<(n5$EdadM-1),0,1-(n5$EdadM-(n5$UCCD0+x)))))
n5$NCCD30=round(n5$PCCD30*30,0)
n5$Deno30=ifelse(is.na(n5$NCCD30),NA,30)
n5$N5ATE <- ifelse(n5$N5PIP==1 & n5$N5CC0==1,1,0)
n5$NuConDN=ifelse(n5$NuConDN>20,NA,n5$NuConDN)
x=1.5
ifelse(n5$Periodo==1,NA,
	ifelse(!is.na(n5$EdadM) & !is.na(n5$ConAL) & (
	(n5$EdadM<0.0657                  )  |
	(n5$EdadM>=0.0657 & n5$EdadM<0.23 & n5$CREDU!=(-1) & (n5$CREDU/30.4375)<=(x*(n5$EdadM-0.0657))) |
	(n5$EdadM>=0.23 & n5$EdadM<1      & n5$CREDU!=(-1) & (n5$CREDU/30.4375)<=(x*(n5$EdadM-0.23))) |
	(n5$EdadM>=1 & n5$EdadM<2         & n5$CREDU!=(-1) & (n5$CREDU/30.4375)<=(x*(n5$EdadM-1))) | 
	(n5$EdadM>=2 & n5$EdadM<4         & n5$CREDU!=(-1) & (n5$CREDU/30.4375)<=(x*(n5$EdadM-2))) | 
	(n5$EdadM>=4 & n5$EdadM<6         & n5$CREDU!=(-1) & (n5$CREDU/30.4375)<=(x*(n5$EdadM-4))) | 
	(n5$EdadM>=6 & n5$EdadM<7         & n5$CREDU!=(-1) & (n5$CREDU/30.4375)<=(x*(n5$EdadM-6))) | 
	(n5$EdadM>=7 & n5$EdadM<9         & n5$CREDU!=(-1) & (n5$CREDU/30.4375)<=(x*(n5$EdadM-7))) | 
	(n5$EdadM>=9 & n5$EdadM<12        & n5$CREDU!=(-1) & (n5$CREDU/30.4375)<=(x*(n5$EdadM-9))) | 
	(n5$EdadM>=12 & n5$EdadM<24       & n5$CREDU!=(-1) & (n5$CREDU/30.4375)<=(x*(3.0*((n5$EdadM/3.0)-as.integer(n5$EdadM/3.0))))) | 
	(n5$EdadM>=24                     & n5$CREDU!=(-1) & (n5$CREDU/30.4375)<=(x*(6.0*((n5$EdadM/6.0)-as.integer(n5$EdadM/6.0))))) 
	),1,0) ) -> n5$IPCREDU
y <- c (0,0.0657,0.23,1,2,4,6,7,9,12,15,18,21,24,30,36,48,60)
n5$dcred = ifelse(is.na(n5$CREDU),NA,
	ifelse((n5$EdadM*30.4375)<30,(n5$EdadM*30.4375),
	ifelse(n5$CREDU>=0 & n5$CREDU<30,n5$CREDU,30)))
n5$icred = ifelse(is.na(n5$CREDU),NA,ifelse(n5$CREDU<n5$dcred,1,0))
ifelse(n5$EdadM<60 & !is.na(n5$ConAL) & !is.na(n5$NMSD) & !is.na(n5$NMCCD) &
	(n5$MaOK==1 & n5$NMSD==1 & n5$NMCCD>0),1,0) -> n5$N5CPR
ifelse(n5$EdadM<60 & !is.na(n5$VivOK) & n5$VivOK==1,1,0) -> n5$N5VIV
ifelse(n5$EdadM<60 & !is.na(n5$ConAL) & (
	n5$CUI==1 & (n5$SIS==1|n5$SIS==2) & (n5$NBI==0 | (n5$NBI>0 & n5$NBAA>0 & n5$NJtos>0 & n5$NPapB>0))),1,0) -> n5$N5COM
n5$N5PRO <- ifelse(n5$N5Nut==1 & n5$N5Ali==1 & n5$N5San==1 & n5$N5ATE==1 & n5$N5CPR==1 & n5$N5VIV==1 & n5$N5COM==1,1,0)
n5$INEIER<-as.numeric(n5$Estrato)
n5$INEIE4=ifelse(n5$INEIE8>=6,6,ifelse(n5$INEIE8>=3 & n5$INEIE8<6,3,n5$INEIE8))
n5$INEIE2=ifelse(n5$INEIE8>=6,6,ifelse(n5$INEIE8>=1 & n5$INEIE8<6,1,n5$INEIE8))
n5$Periodo = factor(n5$Periodo,labels=c("2008-I","2008-III","2008-IV"))
n5$Sexo = factor(n5$Sexo,labels=c("Masculino","Femenino"))
n5$fHV109 = factor(ifelse(n5$HV109==0,7,n5$HV109))
n5$fINEIE8 = factor(n5$INEIE8,labels=c(">100000","20001-100000","10001-20000","4001-10000","401-4000","<401","AER Simple","AER Compuesto"))
n5$fINEIE4 = factor(n5$INEIE4)
n5$fINEIE2 = factor(n5$INEIE2,labels=c("Urbano","Rural"))
n5$Crecer = factor(ifelse(n5$EtapaC>0,1,2),labels=c("Crecer","Resto"))
n5$fNBI = factor(ifelse(n5$NBI>1,2,n5$NBI),labels=c("ninguna","1",">1"))
n5$fecha=as.date("1/1/1960", order="dmy")+ifelse(nchar(as.character(n5$FEnc))==0,NA,as.date(substr(as.character(n5$FEnc),1,10), order="dmy"))
n5$iyear=as.numeric(format(as.Date(n5$fecha),"%Y"))
n5$imonth=as.numeric(format(as.Date(n5$fecha),"%m"))
n5$ijdoy=as.integer(difftime(as.Date(n5$fecha),as.Date(paste(as.character(n5$iyear),"-01-01",sep="")),unit="days"))
n5$WkDay=0
for (i in 1:length(n5$WkDay)) n5$WkDay[i]<-WkOrDay(weekdays(as.Date(n5$fecha[i]),abbreviate=TRUE))
n5$EvEpiWk=as.integer(difftime(as.Date(n5$fecha),as.Date("1960-01-01"),unit="weeks"))
n5$EvEpiMo=as.integer(n5$EvEpiWk/4)
n5$IPConLM=ifelse(n5$ConLM==2,0,n5$ConLM)
n5$IPVComio=ifelse(n5$VComio>=3,1,0)
n5$IPVitA=ifelse(n5$Periodo=="2008-III",NA,ifelse(n5$VitA==1,1,0))
n5$IPVFe=ifelse(n5$Periodo=="2008-III",NA,ifelse(n5$VFe>5,1,0))
n5$IPSal15=ifelse(is.na(n5$SalRx),NA,ifelse(n5$SalRx>=3,1,0))
n5$IPSalRx=ifelse((n5$Periodo=="2008-I")|is.na(n5$SalRx),NA,ifelse(n5$SalRx>=4,1,0))
n5$IPPFie2w=ifelse(n5$PFie2w==1,1,0)
n5$IPPTos2w=ifelse(n5$PTos2w==1,1,0)
n5$IPPDia2w=ifelse(n5$PDia2w==1,1,0)
n5$IPNVBCG=ifelse(n5$NVBCG>0,1,0)
n5$IPNVPOL=ifelse(n5$NVPOL>2,1,0)
n5$IPNVDPT=ifelse(n5$NVDPT>2,1,0)
n5$IPNVHEP=ifelse(n5$NVHEP>2,1,0)
n5$IPNVHIB=ifelse(n5$NVHIB>2,1,0)
n5$IPNVSAR=ifelse(n5$NVSAR>0,1,0)
n5$IPNVPaR=ifelse(n5$NVPaR>0,1,0)
n5$IPNVAMA=ifelse(n5$NVAMA>0,1,0)
n5$IPMaEdu1=ifelse(n5$MaEdu>1,1,0)
n5$IPMaEdu2=ifelse(n5$MaEdu>2,1,0)
n5$IPMaEdu3=ifelse(n5$MaEdu>3,1,0)
n5$IPNMSD=ifelse(n5$NMSD==1,1,0)
n5$IPNMCCD=ifelse(n5$NMCCD>0,1,0)
n5$IPAlumbra=ifelse(n5$Alumbra==1,1,0)
n5$IPAgua=ifelse(n5$Agua==1,1,0)
n5$IPAgRTC=ifelse(n5$AgRT==2 | n5$AgRT==3,1,0)
n5$IPAgRTH=ifelse(n5$AgRT==1 | n5$AgRT==3,1,0)
n5$IPAgBac=1-ifelse(n5$AgBac>0,1,n5$AgBac)
n5$IPAgSeg=ifelse(n5$IPAgua==1 & n5$IPAgRTC==1 & n5$IPAgRTH==1 & n5$IPAgBac==1,1,ifelse(is.na(n5$IPAgBac),NA,0))
n5$IPExcre1=ifelse(n5$Excre==1,1,0)
n5$IPExcre3=ifelse(n5$Excre==3 & n5$LetOK==1,1,0)
n5$IPTCoc1=ifelse(n5$TCoc==1,1,0)
n5$IPTCoc2=ifelse(n5$TCoc==2,1,0)
n5$IPCUI=ifelse(n5$CUI==1,1,0)
n5$IPNBI=ifelse(n5$NBI>0,1,0)
n5$IPNJtos=ifelse(n5$NJtos>0,1,0)
n5$IPSIS=ifelse(n5$SIS==1|n5$SIS==2,1,0)
n5$IPSeg=ifelse(n5$Seguro!=6,1,0)
n5$IPNBAA=ifelse(n5$NBAA>0,1,0)
n5$IPNPapB=ifelse(n5$NPapB>0,1,0)
n5$IPNBPIN=ifelse(n5$NBPIN>0,1,0)
n5$IPEBPIN=ifelse(n5$EBPIN>0,1,0)
n5$IPNBWW=ifelse(n5$NBWW>0,1,0)
n5$IPNBCOI=ifelse(n5$NBCOI>0,1,0)
n5$IPNBTBC=ifelse(n5$NBTBC>0,1,0)
n5$IPNBCOP=ifelse(n5$NBCOP>0,1,0)
n5$IPNBPRV=ifelse(n5$NBPRV>0,1,0)
n5$IPNBVAL=ifelse(n5$NBVAL>0,1,0)
n5$EJtos = factor(ifelse(n5$NJtos>0,1,0) + 2*ifelse(n5$NBI>0,1,0),labels=c("E-J-","E-J+","E+J-","E+J+"))
n5$ESIS  = factor(ifelse(!is.na(n5$SIS) & !is.na(n5$NBI),ifelse((n5$SIS==1|n5$SIS==2),1,0) + 2*ifelse(n5$NBI>0,1,0),0),labels=c("E-S-","E-S+","E+S-","E+S+"))
n5$EPIN  = factor(ifelse(n5$NBPIN>0,1,0) + 2*ifelse(n5$NBI>0,1,0),labels=c("E-P-","E-P+","E+P-","E+P+"))
n5$EVL   = factor(ifelse(n5$NBVAL>0,1,0) + 2*ifelse(n5$NBI>0,1,0),labels=c("E-V-","E-V+","E+V-","E+V+"))
n5$ESI8H9 = as.numeric(n5$Estrato)*100+n5$INEIE8*10+n5$HV109
n5$cagua = ifelse(is.na(n5$Agua),NA,ifelse(n5$Agua<=2,1,0))
n5$Edad2 = n5$EdadM^2
n5$FALT2 = n5$FALT^2
n5$ALMPM = sqrt((n5$FLAT+(12+2/60+45.59/60/60))^2+(n5$FLON+(77+1/60+49.97/60/60))^2)
n5$csexo = 2 - as.numeric(n5$Sexo)
n5$nHV109 = ifelse(n5$HV109==1,3,ifelse(n5$HV109==2,6,ifelse(n5$HV109==3,8.5,ifelse(n5$HV109==4,11,ifelse(n5$HV109==5,15,0)))))
n5$nINEIE8 = ifelse(n5$INEIE8==1,(5000-100)/2,ifelse(n5$INEIE8==2,(100-20)/2,ifelse(n5$INEIE8==3,(20-10)/2,ifelse(n5$INEIE8==4,(10-4)/2,ifelse(n5$INEIE8==5,(4-0.4)/2,ifelse(n5$INEIE8==6,(0.4-0.2)/2,ifelse(n5$INEIE8==7,(0.2-0.1)/2,ifelse(n5$INEIE8==8,(0.1-0)/2,0))))))))
n5$lINEIE8 = log(n5$nINEIE8)
n5$fINEIER = factor(n5$INEIER)
n5$MaEdA2 = n5$MaEdA^2
n5$gMaEdad = 5*as.integer(n5$MaEdA/5)
n5$nVertOc = 2 - n5$VertOc 	# 1 occidente, 0 oriente
n5$lCampoD=log(n5$CampoD)
n5$conret = ifelse(is.na(n5$Retinol),0,1)
n5<-subset(n5,n5$StatusM!=15 & n5$EdadM>=0 & n5$EdadM<60)
n5<-subset(n5,n5$Periodo!="2008-IV")	# PROVISIONAL, MIENTRAS SE DEFINE MONIN XXI
n5$P1R=n5$P1R*(1E-9)
n5$P2R=n5$P2R*(1E-6)
n5$P1N=n5$P1N*(1E-9)
n5$P1M=n5$P1M*(1E-9)
n5$ExFNi=n5$SWt*2472049/sum(n5$SWt)
n5$SWtNi=n5$SWt*length(n5$SWt)/sum(n5$SWt)
n5$gedad=factor(ifelse(n5$EdadM<12,6*as.integer(n5$EdadM/6),12*as.integer(n5$EdadM/12)),
	labels=c("0-5m","6-11m","12-23m","24-35m","36-47m","48-59m"))
x<-aggregate(x=data.frame(SWt=n5$SWt,INEIE8=as.numeric(n5$INEIE8),
	Salida=n5$Salida,Periodo=as.numeric(n5$Periodo),EvEpiWk=n5$EvEpiWk),
	by=list(n5$Estrato,n5$Cong1,n5$Cong2),FUN=max,na.rm=TRUE)
w<-aggregate(x=n5[c("N5Nut", "N5NutD", "N5DTED","N5DTE","N5OBED","N5OBE","N5AneD","N5Ane",
	"N5AliD","N5CCDD","N5CC0D","N5Ali","N5San","N5SaY","N5PIP","N5CCD","N5CC0","N5ATE","N5CPR","N5VIVD","N5VIV","N5COM","N5PRO")],
	by=list(n5$Estrato,n5$Cong1,n5$Cong2),FUN=sum,na.rm=TRUE)
v<-aggregate(x=n5[c("IdM")],
	by=list(n5$Estrato,n5$Cong1,n5$Cong2),FUN=length)
w<-merge(x=w,y=x,by=c("Group.1", "Group.2", "Group.3"),all.y=TRUE)
v5<-merge(x=v,y=w,by=c("Group.1", "Group.2", "Group.3"),all.y=TRUE)
v5$Estrato=v5$Group.1; v5$Cong1=v5$Group.2; v5$Cong2=v5$Group.3
v5$ExFVi=v5$SWt*7255503/sum(v5$SWt)
v5$SWtVi=v5$SWt*length(v5$SWt)/sum(v5$SWt)
n3<-subset(n5,n5$EdadM<36)
n3$ExFNi=n3$SWt*2472049*(3/5)/sum(n3$SWt)
n3$SWtNi=n3$SWt*length(n3$SWt)/sum(n3$SWt)
mf<-read.csv("M.csv") 
mf$one = 1
mf$P1R=mf$P1R*(1E-9)
mf$P2R=mf$P2R*(1E-6)
mf$Crecer=factor(ifelse(mf$EtapaC>0,1,2),labels=c("Crecer","Resto"))
mf$RegNat = factor(ifelse(mf$Estrato==1|mf$Estrato==2,1,ifelse(mf$Estrato==5,3,2)),labels=c("Costa","Sierra","Selva"))
mf$Estrato=factor(mf$Estrato,labels=c("Lima M","R Costa","Sierra U","Sierra R","Selva"))
mf$INEIE4=ifelse(mf$INEIE8>=6,6,ifelse(mf$INEIE8>=3 & mf$INEIE8<6,3,mf$INEIE8))
mf$INEIE2=ifelse(mf$INEIE8>=6,6,ifelse(mf$INEIE8>=1 & mf$INEIE8<6,1,mf$INEIE8))
mf$fINEIE8 = factor(mf$INEIE8,labels=c(">100000","20001-100000","10001-20000","4001-10000","401-4000","<401","AER Simple","AER Compuesto"))
mf$fINEIE4 = factor(mf$INEIE4)
mf$fINEIE2 = factor(mf$INEIE2,labels=c("Urbano","Rural"))
mf$Periodo = factor(mf$Periodo,labels=c("2008-I","2008-III"))	# ,"2008-IV"
mf$fNBI = factor(ifelse(mf$NBI>1,2,mf$NBI),labels=c("ninguna","1",">1"))
mf$gedad=factor(5*as.integer(mf$Edad/5),
	labels=c("12-14a","15-19a","20-24a","25-29a","30-34a","35-39a","40-44a","45-49a"))
mf$Sexo = factor(c(1,2),labels=c("Masculino","Femenino"))
mf$Sexo = "Femenino"
mf$StatYU=ifelse(mf$EFisM==3,
	ifelse(mf$Yoduria<100,1,ifelse(mf$Yoduria>=200,3,2)),
	ifelse(mf$Yoduria<150,1,ifelse(mf$Yoduria>=250,3,2)))
mf$IPOBE = ifelse(is.na(mf$PesoKgSR)|is.na(mf$TallaCm),NA,ifelse((mf$PesoKgSR/(mf$TallaCm/100)/(mf$TallaCm/100))>25,1,0))
mf$IPRET = ifelse(is.na(mf$Retinol),NA,ifelse(mf$Retinol<20,1,0))
mf$IPYOD = ifelse(is.na(mf$Yoduria),NA,ifelse(mf$Yoduria<10,1,0))
mf$IPANE = ifelse(is.na(mf$HbCORR),NA,ifelse(mf$HbCORR<ifelse(mf$EFisM==1|mf$EFisM==4,11,12),1,0))
mf$EFisM = ifelse(mf$EFisM==0|mf$EFisM==9,9,mf$EFisM)
mf$EFisM = factor(mf$EFisM, labels=c("Gestante","Lactante","No G No L","G y L","Ignorado"))
mf$conyod=ifelse(is.na(mf$Yoduria),0,1)
mf$conret=ifelse(is.na(mf$Retinol),0,1)
mf<-subset(mf,mf$StatusM!=15)
mf$ExFMu=mf$SWt*6974633/sum(mf$SWt)
mf$SWtMu=mf$SWt*length(mf$SWt)/sum(mf$SWt)
p5<-svydesign(id=~Cong1+Cong2, strata=~Estrato, weights=~SWtNi, data=n5)
p3<-svydesign(id=~Cong1+Cong2, strata=~Estrato, weights=~SWtNi, data=n3)
s5<-svydesign(id=~Cong1+Cong2, strata=~Estrato, weights=~SWtVi, data=v5)
pf<-svydesign(id=~Cong1+Cong2, strata=~Estrato, weights=~SWtMu, data=mf)
v=1; w=1; x=1; y=1
save.image( "M.RData" )
load( "M.RData" )
objects()
summ(n5); summ(v5); summary(p5); summary(s5)
summ(n3); summary(p3)
summ(mf); summary(pf)
date()
#options(survey.lonely.psu = "certainty")

# ======================================================================================================================== #

q("no")
